/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.common;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public final class TagManager {
    public static ResourceLocation identifier(String path) {
        return new ResourceLocation("tcintegrations", path);
    }

    public static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    public static final class EntityTypes {
        public static final TagKey<EntityType<?>> ELEMENTAL_SEVERING_MOBS = EntityTypes.create("elemental_severing_mods");

        private static TagKey<EntityType<?>> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.ENTITIES.tags()).createOptionalTagKey(TagManager.identifier(id), Collections.emptySet());
        }
    }

    public static final class Blocks {
        public static final TagKey<Block> BRONZE = Blocks.forgeTag("storage_blocks/bronze");
        public static final TagKey<Block> SOUL_STAINED_STEEL = Blocks.forgeTag("storage_blocks/soul_stained_steel");

        private static TagKey<Block> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).createOptionalTagKey(TagManager.identifier(id), Collections.emptySet());
        }

        private static TagKey<Block> forgeTag(String name) {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).createOptionalTagKey(TagManager.forgeLoc(name), Collections.emptySet());
        }
    }

    public static final class Items {
        public static final TagKey<Item> BRONZE = Items.forgeTag("storage_blocks/bronze");
        public static final TagKey<Item> BRONZE_INGOTS = Items.forgeTag("ingots/bronze");
        public static final TagKey<Item> BRONZE_NUGGETS = Items.forgeTag("nuggets/bronze");
        public static final TagKey<Item> BOTANIA_LIVINGWOOD_LOGS = Items.create("livingwood_logs");
        public static final TagKey<Item> SOUL_STAINED_STEEL = Items.forgeTag("storage_blocks/soul_stained_steel");
        public static final TagKey<Item> SOUL_STAINED_STEEL_INGOTS = Items.forgeTag("ingots/soul_stained_steel");
        public static final TagKey<Item> SOUL_STAINED_STEEL_NUGGETS = Items.forgeTag("nuggets/soul_stained_steel");
        public static final TagKey<Item> EMERALDITE_SHARDS = Items.create("emeraldite_shards");
        public static final TagKey<Item> EMERALDITE_ORE = Items.create("emeraldite_ore");
        public static final TagKey<Item> PENDORITE_ALLOY_INGOTS = Items.forgeTag("ingots/pendorite_alloy");

        private static TagKey<Item> create(String id) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(TagManager.identifier(id), Collections.emptySet());
        }

        private static TagKey<Item> forgeTag(String name) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(TagManager.forgeLoc(name), Collections.emptySet());
        }
    }
}

